'''
innerlook.py

送信側のoutlookで作成されたリッチテキストのメール本文は、
受信側がoutlookでない場合、プレーンテキストで表示されるようだ。
従って、添付ファイルのみ抽出できれば問題ない。
※
rtf形式のリッチテキストもwinmail.datに含まれるはずなのだが
文字化けしてうまく取り出せないのが心残り。

'''

from tkinter import *
import tkinter.messagebox as mbx
#import tkinter.simpledialog as sdlg
import tkinter.filedialog as fldlg
from tnefparse.tnef import TNEF
import os,sys
from . import scrollbar_inc as scrli

VERSION = '0.5.1'

def errexit(msg):
  global root
  mbx.showerror('エラー',msg,parent=root)
  sys.exit()
  
class mainwindow():
  def __init__(self,root=None):
    self.root = root
    self.tnefobj = None
##    fr = Frame(root)
##    Label(fr,text='winmail.dat（又はtnef形式ファイル）に含まれる').pack(anchor='w')
##    Label(fr,text='添付ファイルを抽出します').pack(anchor='w')
##    fr.pack()

    fr = LabelFrame(root,text='対象ファイル(tnefファイル:winmail.datなど)')
    self.targetvar = StringVar()
    self.targetpath = Entry(fr,textvariable=self.targetvar,state=DISABLED,
                            disabledforeground='black')
    self.seltargetbtn = Button(fr,text='選択',command=self.seltarget)
    self.targetpath.pack(side=LEFT,expand=1,fill='x')
    self.seltargetbtn.pack(side=LEFT)
    #fr.pack(expand=1,fill='x')
    fr.grid(row=0,column=0,sticky=W+E,padx=5,pady=5)
    #StringVar.trace
    self.targetvar.trace('w',self.chgtarget)
    
    fr = LabelFrame(root,text='添付ファイル一覧')
    self.attchtx = Text(fr,state=DISABLED,width=70,height=5)
    fr = scrli.scrollbarset(fr,self.attchtx)
    #fr.pack(expand=1,fill=BOTH,padx=4,pady=4)
    fr.grid(row=1,column=0,sticky=W+E+N+S,padx=5,pady=5)
    
    fr = Frame(root)
    Label(fr,text='※添付ファイルの抽出先は対象ファイルと同じディレクトリです').pack(
      anchor='w')
    Label(fr,text='（同名ファイルが存在する場合は上書きされます。）').pack(
      anchor='w')
    #fr.pack()
    fr.grid(row=2,column=0)

    fra = Frame(root)
    fr = Frame(fra)
    self.dobtn = Button(fr,text='抽出実行',command=self.extract)
    self.clearbtn = Button(fr,text='クリア',command=self.clear)
    self.exitbtn = Button(fr,text='終了',command=self.exit)
    self.dobtn.pack(side=LEFT)
    self.clearbtn.pack(side=LEFT)
    self.exitbtn.pack(side=LEFT)
    fr.pack()
    #fra.pack(expand=1,fill='x',padx=4,pady=4)
    fra.grid(row=3,column=0,padx=5,pady=5)

    #grid weight
    root.columnconfigure(0,weight=1)
    root.rowconfigure(1,weight=1)

    #初期化
    self.clear()

  def gettnefobj(self):
    try:
      with open(self.targetvar.get(),'rb') as fp:
        tnefdata = fp.read()
      tnefobj = TNEF(tnefdata)
    except Exception as err:
      msg = '「{}」は扱えません'.format(self.targetvar.get())
      mbx.showerror('エラー',msg,parent=self.root)
      return None
    return tnefobj

  def chgtarget(self,*args):
    if not self.targetvar.get():
      self.dobtn['state'] = DISABLED
    else:
      self.tnefobj = self.gettnefobj()
      if not self.tnefobj:
        self.clear()
        return
      #添付ファイルリストを得る
      cnt = len(self.tnefobj.attachments)
      if not cnt:
        msg = '「{}」には添付ファイルがありません'.format(self.targetvar.get())
        mbx.showinfo('通知',msg,parent=self.root)
        return
      #一旦テキストボックスをクリアしてからリストを挿入
      self.attchtx['state'] = NORMAL
      self.attchtx.delete('0.0',END)
      for attch in self.tnefobj.attachments:
        self.attchtx.insert(END,attch.long_filename()+'\n')
      self.attchtx['state'] = DISABLED
      self.dobtn['state'] = NORMAL
  
  def seltarget(self):
    f = fldlg.askopenfilename(title='winmail.dat等対象ファイルの指定',
                              parent=self.root)
    if f:
      self.targetvar.set(f)

  def extract(self):
    #解凍先ディレクトリ
    fdir = os.path.dirname(self.targetvar.get())
    try:
      for attch in self.tnefobj.attachments:
        with open(os.path.join(fdir,attch.long_filename()),'wb') as fp:
          fp.write(attch.data)
    except Exception as err:
      msg = '「{}」を抽出中にエラーが発生しました'.format(attch.long_filename())
      mbx.showerror('エラー',msg,parent=self.root)
      return
    msg = '対象ファイルと同じディレクトリに抽出しました'
    mbx.showinfo('通知',msg,parent=self.root)

  def clear(self):
    self.targetvar.set('')
    self.attchtx['state'] = NORMAL
    self.attchtx.delete('0.0',END)
    self.attchtx['state'] = DISABLED

  def exit(self):
    root.destroy()
  
def rootwin(title=None):
  global root
  root = Tk()
  if title:
    root.title(title)
  return root

def main():
  root = rootwin('InnerLook: winmail.datから添付ファイルを抽出')
  mainw = mainwindow(root)
  root.mainloop()

#-----------------------------------
if __name__=='__main__':
  main()
  
  
